/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "x86emu.h"

//-----------------------------------------------------------------------------------------------------------------------
int Process::ImportTableFixup(dword FileHandler){
     image_header* PEHeader=(image_header*)(((dos_header*)FileHandler)->e_lfanew + FileHandler);
     image_import_descriptor* Imports=(image_import_descriptor*)(PEHeader->optional.data_directory[1].virtual_address+FileHandler);
     for (int i=0;i<100;i++){
         if (Imports->original_first_thunk==0 && Imports->first_thunk==0 && Imports->name==0)break;
         dword name=Imports->name + FileHandler;
         dword dllbase=sys->GetDllBase((char*)name);
         APIsFixup(FileHandler,Imports,dllbase);
         Imports=(image_import_descriptor*)((dword)Imports+(dword)sizeof(image_import_descriptor));
     };
};
//-----------------------------------------------------------------------------------------------------------------------
int Process::APIsFixup(dword FileHandler,image_import_descriptor* Imports,dword dllbase){
    image_import_by_name** names;                                       //pointer to the names that we will get's address
    dword* pointers;                                    //pointer to the the place that we will put the addresses there                                 
    if (Imports->original_first_thunk!=0){
       names=(image_import_by_name**)Imports->original_first_thunk;                                               
       
    }else{
          names=(image_import_by_name**)Imports->first_thunk;
    };
    names=(image_import_by_name**)((dword)names+FileHandler);
    pointers=(dword*)(Imports->first_thunk + FileHandler);
    //cout << (int*)FileHandler << "\n";                                            
    for (int i=0;i<200;i++){
        if (names[i]==0)break;
        if(!((dword)(names[i]->name+FileHandler) & 0x80000000)){
            dword s=(dword)names[i]->name;
            dword ptr=sys->GetAPI((char*)(s+FileHandler),dllbase);
            dword n=this->SharedMem->get_virtual_pointer(ptr);
            //if (dllbase)
            //cout << (int*)dllbase << "   " << (int*)ptr << "\n";
            if (n!=0){
               ptr=n;
            }else{
                  n=sys->DLLs[0].imagebase; //equal to the kernel32 base address    
            }
            //pointers[i]=ptr;
            memcpy(&pointers[i],&ptr,4);
        }
    };
};
//-----------------------------------------------------------------------------------------------------------------------

Process::Process (System* sys,string filename)
{      
       //1.open the file
       dword FileHandler=PELoader(filename);
       if(FileHandler==0)throw (ERROR_FILENAME);
       
       //2.initialize the System 
       this->sys=sys;
       //3.initalize the Shared Memory
       
       this->SharedMem=new VirtualMemory();
       image_header* PEHeader;
       PEHeader=(image_header*)(((dos_header*)FileHandler)->e_lfanew + FileHandler);
       Imagebase=PEHeader->optional.image_base; //the imagebase
       this->SharedMem->add_pointer(FileHandler,PEHeader->optional.image_base,PEHeader->optional.size_of_image,MEM_IMAGEBASE);
       for (int i=0;i<sys->dll_entries;i++){
           if (sys->DLLs[i].vAddr!=0){
              this->SharedMem->add_pointer(sys->DLLs[i].imagebase,sys->DLLs[i].vAddr,sys->DLLs[i].size,MEM_DLLBASE);
           }else{
                 this->SharedMem->add_pointer(sys->DLLs[i].imagebase,sys->DLLs[i].imagebase,sys->DLLs[i].size,MEM_DLLBASE);
           };
       };
       // 4.fix the import table
       ImportTableFixup(FileHandler);
       //5.initialize the debugger
       debugger=new Debugger(*this);
       //6.initialize the PEB
       CreatePEB();
       //7.initialize the first thread
       nthreads=0;
       this->MaxIterations=sys->enVars.MaxIterations;
       CreateThread(PEHeader->optional.address_of_entry_point+PEHeader->optional.image_base);
       threads[0]->stack->push(threads[0]->mem->get_virtual_pointer(sys->APITable[0].addr));             //pushes the pointer to ExitProcess (some viruses get the kernelbase from it 
       ins=(ins_disasm*)malloc(sizeof(ins_disasm)); //preparing the buffer for instructions
};
//this proc copy all the shared memory entries on every thread memory to become visible for each thread
//all the threads will see the changes in the shared memory as the shared pointers in all threads point to the same location in memory
System* Process::getsystem(){
        return sys;
};
ins_disasm* Process::GetLastIns(){
            return ins;            
};
int Process::CreateThread(dword ptr)
{
  this->threads[nthreads]=new Thread(ptr,*this);
  //for (int i=0;i<SharedMem->vmem_length;i++){
  //    this->threads[nthreads]->mem->add_pointer(SharedMem->vmem[i]->rmem,SharedMem->vmem[i]->vmem,SharedMem->vmem[i]->size,SharedMem->vmem[i]->flags);
  //};
  nthreads++;  
  return (nthreads-1);
};
//n--> the Thread number
int Process::emulatecommand(int n){
   
    };
int Process::emulatecommand(){
        string str;
    
Continue_th:
    try {
        ins=sys->disasm(ins,(char*)SharedMem->read_virtual_mem(this->threads[0]->Eip));//,str
        bool IsApi=sys->IsApiCall(*threads[0],ins);
        bool bp=this->debugger->TestBp(*threads[0],ins);     
        if (bp && !TiggeredBreakpoint){
               TiggeredBreakpoint=true;
               return EXP_BREAKPOINT;
        }else if (TiggeredBreakpoint){
              TiggeredBreakpoint=false;
        };
        if (IsApi){
           this->threads[0]->log->addlog(this->threads[0]->Eip);
           this->threads[0]->Eip+= ins->hde.len;
           sys->CallToAPI(threads[0],ins);
        }else{
              this->threads[0]->log->addlog(this->threads[0]->Eip);
              this->threads[0]->Eip+= ins->hde.len;
              ins->emu_func(*threads[0],ins);
        };
     return 0; 
    } catch(int x) {
           if(x !=EXP_INVALID_OPCODE)this->threads[0]->Eip-= ins->hde.len;   //because it's added before emulating the instruction
           dword fsptr=*SharedMem->read_virtual_mem(threads[0]->GetFS());
           if (*SharedMem->read_virtual_mem(fsptr)!= 0xFFFFFFFF){
              dword* ptr=(dword*)this->SharedMem->read_virtual_mem(threads[0]->GetFS());
              dword err_ptr = *ptr;
              dword* nextptr=(dword*)this->SharedMem->read_virtual_mem(err_ptr); //the next handler
              threads[0]->generateException(x);      
              *ptr=*nextptr;
              return 0;                                                   //save it        
           }else{
           return x;
           };       
    };
};



//------------------------------------------------------------------------------------------------------
///*
int Process::emulate(){
    
    string str;
    
Continue_th:
    try {
     dword Max=MaxIterations;   
     for (int i=0;i<Max;i++){ 
        ins=sys->disasm(ins,(char*)SharedMem->read_virtual_mem(this->threads[0]->Eip));//,str
        bool IsApi=sys->IsApiCall(*threads[0],ins);
        bool bp=this->debugger->TestBp(*threads[0],ins);     
        if (bp && !TiggeredBreakpoint){
               TiggeredBreakpoint=true;
               return EXP_BREAKPOINT;
        }else if (TiggeredBreakpoint){
              TiggeredBreakpoint=false;
        };
        if (IsApi){
           this->threads[0]->log->addlog(this->threads[0]->Eip);
           this->threads[0]->Eip+= ins->hde.len;
           sys->CallToAPI(threads[0],ins);
        }else{
              this->threads[0]->log->addlog(this->threads[0]->Eip);
              this->threads[0]->Eip+= ins->hde.len;
              ins->emu_func(*threads[0],ins);
        };
        MaxIterations-=1;
     };
     return 0;
    } catch(int x) {
           if(x !=EXP_INVALID_OPCODE)this->threads[0]->Eip-= ins->hde.len;   //because it's added before emulating the instruction
           dword fsptr=*SharedMem->read_virtual_mem(threads[0]->GetFS());
           if (*SharedMem->read_virtual_mem(fsptr)!= 0xFFFFFFFF){
              dword* ptr=(dword*)this->SharedMem->read_virtual_mem(threads[0]->GetFS());
              dword err_ptr = *ptr;
              dword* nextptr=(dword*)this->SharedMem->read_virtual_mem(err_ptr); //the next handler
              threads[0]->generateException(x);      
              *ptr=*nextptr;                                                   //save it        
           }else{
           return x;
           };    
    };
    goto Continue_th;
};
//*/
//------------------------------------------------------------------------------------------------------
/*
int Process::emulate(){
    
    string str;
    FILE *x2;
     x2=fopen("D:\\test.txt", "w");  
Continue_th:
    try {
     dword Max=MaxIterations;   
     for (int i=0;i<Max;i++){ 
        ins=sys->disasm(ins,(char*)SharedMem->read_virtual_mem(this->threads[0]->Eip),str);//
        bool IsApi=sys->IsApiCall(*threads[0],ins);
        bool bp=this->debugger->TestBp(*threads[0],ins);
        //**************************************
        string str1="EAX = ";
        string str3="ESP = ";
        string str4;
        char buff[50];
        string str2[8];
        for (int l=0;l<8;l++){
          sprintf(buff,"%X",threads[0]->Exx[l]);
          str2[l]=buff;
        };
        sprintf(buff,"%X",threads[0]->Eip); 
        str4=buff;
        str4.append(" : ");
        str4.append(str); 
        str1.append(str2[0].append((string("  ECX = ")).append(str2[1].append((string("  EDX = ")).append(str2[2])).append((string("  EBX = ")).append(str2[3].append("\n"))))));
        str3.append(str2[4].append((string("  EBP = ")).append(str2[5].append((string("  ESI = ")).append(str2[6])).append((string("  EDI = ")).append(str2[7].append("\n"))))));
        fprintf(x2,str1.c_str());
        fprintf(x2,str3.c_str());
        fprintf(x2,str4.c_str());
        fprintf(x2,"  \n\n");

        //***************************************     
        if (bp && !TiggeredBreakpoint){
               TiggeredBreakpoint=true;
               fclose(x2);
               return EXP_BREAKPOINT;
        }else if (TiggeredBreakpoint){
              TiggeredBreakpoint=false;
        };
        if (IsApi){
           this->threads[0]->log->addlog(this->threads[0]->Eip);
           this->threads[0]->Eip+= ins->hde.len;
           sys->CallToAPI(threads[0],ins);
        }else{
              this->threads[0]->log->addlog(this->threads[0]->Eip);
              this->threads[0]->Eip+= ins->hde.len;
              ins->emu_func(*threads[0],ins);
        };
        MaxIterations-=1;
     };
     return 0;
    } catch(int x) {
           if(x !=EXP_INVALID_OPCODE)this->threads[0]->Eip-= ins->hde.len;   //because it's added before emulating the instruction
           dword fsptr=*SharedMem->read_virtual_mem(threads[0]->GetFS());
           if (*SharedMem->read_virtual_mem(fsptr)!= 0xFFFFFFFF){
              dword* ptr=(dword*)this->SharedMem->read_virtual_mem(threads[0]->GetFS());
              dword err_ptr = *ptr;
              dword* nextptr=(dword*)this->SharedMem->read_virtual_mem(err_ptr); //the next handler
              threads[0]->generateException(x);      
              *ptr=*nextptr;                                                   //save it        
           }else{
           fclose(x2);      
           return x;
           };    
    };
    goto Continue_th;
};
//*/
//------------------------------------------------------------------------------------------------------
Thread* Process::GetThread(int id){
        return this->threads[id];
};
dword Process::GetImagebase(){
      return Imagebase;
};
void Process::CreatePEB(){
      //creating the PEB
      dword size=sizeof(PEB)+3*sizeof(_LDR_DATA_TABLE_ENTRY)+sizeof(_PEB_LDR_DATA);
      dword ptr=(dword)malloc(size);
      peb=(PEB*)ptr;
      //Preparing the Data Table Entry
      _PEB_LDR_DATA*  LoaderData=(_PEB_LDR_DATA*)(ptr+sizeof(PEB));
      _LDR_DATA_TABLE_ENTRY* program=(_LDR_DATA_TABLE_ENTRY*)(ptr+sizeof(PEB)+sizeof(_PEB_LDR_DATA));
      _LDR_DATA_TABLE_ENTRY* ntdll=(_LDR_DATA_TABLE_ENTRY*)(ptr+sizeof(PEB)+sizeof(_LDR_DATA_TABLE_ENTRY)+sizeof(_PEB_LDR_DATA));
      _LDR_DATA_TABLE_ENTRY* kernel=(_LDR_DATA_TABLE_ENTRY*)(ptr+sizeof(PEB)+2*sizeof(_LDR_DATA_TABLE_ENTRY)+sizeof(_PEB_LDR_DATA));
      memset(peb,0,size);
      
      //filling the entries
      program->DllBase=Imagebase;
      ntdll->DllBase=sys->DLLs[1].vAddr;
      kernel->DllBase=sys->DLLs[0].vAddr;
      
      //Fill the PEB with the important formation
      peb->ImageBaseAddress=Imagebase;//
      
      //Create it
      this->SharedMem->add_pointer((dword)peb,0x7FFD5000,size);
      
      //Filling the pointers
      peb->LoaderData=(_PEB_LDR_DATA*)SharedMem->get_virtual_pointer((dword)LoaderData);
      //LoaderData
      LoaderData->InLoadOrderModuleList.Flink=SharedMem->get_virtual_pointer((dword)program);
      LoaderData->InInitializationOrderModuleList.Flink=SharedMem->get_virtual_pointer((dword)program);
      LoaderData->InMemoryOrderModuleList.Flink=SharedMem->get_virtual_pointer((dword)program);
      
      //Program
      program->InLoadOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)ntdll);
      program->InInitializationOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)ntdll);
      program->InMemoryOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)ntdll);
      
      //ntdll
      ntdll->InLoadOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)kernel);
      ntdll->InInitializationOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)kernel);
      ntdll->InMemoryOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)kernel);
      
      //kernel
      kernel->InLoadOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)program);
      kernel->InInitializationOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)program);
      kernel->InMemoryOrderLinks.Flink=SharedMem->get_virtual_pointer((dword)program);
}
dword Process::SkipIt(){
      this->threads[0]->Eip+= ins->hde.len;
      ins=sys->disasm(ins,(char*)SharedMem->read_virtual_mem(this->threads[0]->Eip));//,str
};
